/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DefaultDataTable;
import com.mckoi.database.InsertSearch;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SelectableRange;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IndexComparator;
import com.mckoi.util.IntegerVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class SelectableScheme {
    protected static final BlockIntegerList EMPTY_LIST = new BlockIntegerList();
    protected static final BlockIntegerList ONE_LIST;
    private final TableDataSource table;
    private final int column;
    private boolean immutable = false;

    public SelectableScheme(TableDataSource table, int column) {
        this.table = table;
        this.column = column;
    }

    protected final TableDataSource getTable() {
        return this.table;
    }

    protected final TransactionSystem getSystem() {
        return this.table.getSystem();
    }

    protected final DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    protected final int getColumn() {
        return this.column;
    }

    protected final TObject getCellContents(int row) {
        return this.table.getCellContents(this.column, row);
    }

    public final void setImmutable() {
        this.immutable = true;
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    public String toString() {
        String table_name = this.table instanceof DefaultDataTable ? ((DefaultDataTable)this.table).getTableName().toString() : "VirtualTable";
        StringBuffer buf = new StringBuffer();
        buf.append("[ SelectableScheme ");
        buf.append(super.toString());
        buf.append(" for table: ");
        buf.append(table_name);
        buf.append("]");
        return new String(buf);
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public abstract void readFrom(InputStream var1) throws IOException;

    public abstract SelectableScheme copy(TableDataSource var1, boolean var2);

    public abstract void dispose();

    abstract void insert(int var1);

    abstract void remove(int var1);

    public BlockIntegerList internalOrderIndexSet(final IntegerVector row_set) {
        int row_set_length = row_set.size();
        if (row_set_length == 0) {
            return EMPTY_LIST;
        }
        if (row_set_length == 1) {
            return ONE_LIST;
        }
        BlockIntegerList new_set = new BlockIntegerList();
        if (row_set_length <= 250000) {
            final TObject[] subset_list = new TObject[row_set_length];
            for (int i = 0; i < row_set_length; ++i) {
                subset_list[i] = this.getCellContents(row_set.intAt(i));
            }
            IndexComparator comparator = new IndexComparator(){

                public int compare(int index, Object val) {
                    TObject cell = subset_list[index];
                    return cell.compareTo((TObject)val);
                }

                public int compare(int index1, int index2) {
                    throw new Error("Shouldn't be called!");
                }
            };
            for (int i = 0; i < row_set_length; ++i) {
                TObject cell = subset_list[i];
                new_set.insertSort(cell, i, comparator);
            }
        } else {
            IndexComparator comparator = new IndexComparator(){

                public int compare(int index, Object val) {
                    TObject cell = SelectableScheme.this.getCellContents(row_set.intAt(index));
                    return cell.compareTo((TObject)val);
                }

                public int compare(int index1, int index2) {
                    throw new Error("Shouldn't be called!");
                }
            };
            for (int i = 0; i < row_set_length; ++i) {
                TObject cell = this.getCellContents(row_set.intAt(i));
                new_set.insertSort(cell, i, comparator);
            }
        }
        return new_set;
    }

    public SelectableScheme getSubsetScheme(Table subset_table, int subset_column) {
        IntegerVector row_set = new IntegerVector(subset_table.getRowCount());
        RowEnumeration e = subset_table.rowEnumeration();
        while (e.hasMoreRows()) {
            row_set.addInt(e.nextRowIndex());
        }
        subset_table.setToRowTableDomain(subset_column, row_set, this.getTable());
        BlockIntegerList new_set = this.internalOrderIndexSet(row_set);
        if (new_set.size() != row_set.size()) {
            throw new RuntimeException("Internal sort error in finding sub-set.");
        }
        InsertSearch is = new InsertSearch((TableDataSource)subset_table, subset_column, new_set);
        is.RECORD_UID = false;
        return is;
    }

    public IntegerVector selectAll() {
        return this.selectRange(new SelectableRange(1, SelectableRange.FIRST_IN_SET, 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectFirst() {
        return this.selectRange(new SelectableRange(1, SelectableRange.FIRST_IN_SET, 2, SelectableRange.FIRST_IN_SET));
    }

    public IntegerVector selectNotFirst() {
        return this.selectRange(new SelectableRange(4, SelectableRange.FIRST_IN_SET, 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectLast() {
        return this.selectRange(new SelectableRange(1, SelectableRange.LAST_IN_SET, 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectNotLast() {
        return this.selectRange(new SelectableRange(1, SelectableRange.FIRST_IN_SET, 3, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectAllNonNull() {
        return this.selectRange(new SelectableRange(4, TObject.nullVal(), 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectEqual(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(1, ob, 2, ob));
    }

    public IntegerVector selectNotEqual(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange[]{new SelectableRange(4, TObject.nullVal(), 3, ob), new SelectableRange(4, ob, 2, SelectableRange.LAST_IN_SET)});
    }

    public IntegerVector selectGreater(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(4, ob, 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectLess(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(4, TObject.nullVal(), 3, ob));
    }

    public IntegerVector selectGreaterOrEqual(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(1, ob, 2, SelectableRange.LAST_IN_SET));
    }

    public IntegerVector selectLessOrEqual(TObject ob) {
        if (ob.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(4, TObject.nullVal(), 2, ob));
    }

    public IntegerVector selectBetween(TObject ob1, TObject ob2) {
        if (ob1.isNull() || ob2.isNull()) {
            return new IntegerVector(0);
        }
        return this.selectRange(new SelectableRange(1, ob1, 3, ob2));
    }

    abstract IntegerVector selectRange(SelectableRange var1);

    abstract IntegerVector selectRange(SelectableRange[] var1);

    static {
        EMPTY_LIST.setImmutable();
        ONE_LIST = new BlockIntegerList();
        ONE_LIST.add(0);
        ONE_LIST.setImmutable();
    }
}

